/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.RelativePathUtil;

@Incubating
public class JacocoTaskExtension {
    private final JacocoAgentJar agent;
    private final JavaForkOptions task;
    private boolean enabled = true;
    private final Property<File> destinationFile;
    private boolean append = true;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private List<String> excludeClassLoaders = new ArrayList<String>();
    private boolean includeNoLocationClasses;
    private String sessionId;
    private boolean dumpOnExit = true;
    private Output output = Output.FILE;
    private String address;
    private int port;
    private File classDumpDir;
    private boolean jmx;

    public JacocoTaskExtension(Project project, JacocoAgentJar agent, JavaForkOptions task) {
        this.agent = agent;
        this.task = task;
        this.destinationFile = project.getObjects().property(File.class);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public File getDestinationFile() {
        return (File)this.destinationFile.getOrNull();
    }

    public void setDestinationFile(Provider<File> destinationFile) {
        this.destinationFile.set(destinationFile);
    }

    public void setDestinationFile(File destinationFile) {
        this.destinationFile.set(destinationFile);
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getExcludeClassLoaders() {
        return this.excludeClassLoaders;
    }

    public void setExcludeClassLoaders(List<String> excludeClassLoaders) {
        this.excludeClassLoaders = excludeClassLoaders;
    }

    public boolean isIncludeNoLocationClasses() {
        return this.includeNoLocationClasses;
    }

    public void setIncludeNoLocationClasses(boolean includeNoLocationClasses) {
        this.includeNoLocationClasses = includeNoLocationClasses;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isDumpOnExit() {
        return this.dumpOnExit;
    }

    public void setDumpOnExit(boolean dumpOnExit) {
        this.dumpOnExit = dumpOnExit;
    }

    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public File getClassDumpDir() {
        return this.classDumpDir;
    }

    public void setClassDumpDir(File classDumpDir) {
        this.classDumpDir = classDumpDir;
    }

    public boolean isJmx() {
        return this.jmx;
    }

    public void setJmx(boolean jmx) {
        this.jmx = jmx;
    }

    public String getAsJvmArg() {
        StringBuilder builder = new StringBuilder();
        ArgumentAppender argument = new ArgumentAppender(builder, this.task.getWorkingDir());
        builder.append("-javaagent:");
        builder.append(RelativePathUtil.relativePath(this.task.getWorkingDir(), this.agent.getJar()));
        builder.append('=');
        argument.append("destfile", this.getDestinationFile());
        argument.append("append", this.isAppend());
        argument.append("includes", this.getIncludes());
        argument.append("excludes", this.getExcludes());
        argument.append("exclclassloader", this.getExcludeClassLoaders());
        if (this.agent.supportsInclNoLocationClasses()) {
            argument.append("inclnolocationclasses", this.isIncludeNoLocationClasses());
        }
        argument.append("sessionid", this.getSessionId());
        argument.append("dumponexit", this.isDumpOnExit());
        argument.append("output", this.getOutput().getAsArg());
        argument.append("address", this.getAddress());
        argument.append("port", this.getPort());
        argument.append("classdumpdir", this.getClassDumpDir());
        if (this.agent.supportsJmx()) {
            argument.append("jmx", this.isJmx());
        }
        return builder.toString();
    }

    private static class ArgumentAppender {
        private final StringBuilder builder;
        private final File workingDirectory;
        private boolean anyArgs;

        public ArgumentAppender(StringBuilder builder, File workingDirectory) {
            this.builder = builder;
            this.workingDirectory = workingDirectory;
        }

        public void append(String name, Object value) {
            if (!(value == null || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof String && StringUtils.isEmpty((String)((String)value)) || value instanceof Integer && value == Integer.valueOf(0))) {
                if (this.anyArgs) {
                    this.builder.append(',');
                }
                this.builder.append(name).append('=');
                if (value instanceof Collection) {
                    this.builder.append(Joiner.on((char)':').join((Iterable)((Collection)value)));
                } else if (value instanceof File) {
                    this.builder.append(RelativePathUtil.relativePath(this.workingDirectory, (File)value));
                } else {
                    this.builder.append(value);
                }
                this.anyArgs = true;
            }
        }
    }

    public static enum Output {
        FILE,
        TCP_SERVER,
        TCP_CLIENT,
        NONE;


        public String getAsArg() {
            return this.toString().toLowerCase().replaceAll("_", "");
        }
    }
}

