/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.Arrays;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.util.DeprecationLogger;

public final class NameValidator {
    private static final char[] FORBIDDEN_CHARACTERS = new char[]{' ', '/', '\\', ':', '<', '>', '\"', '?', '*', '|'};
    private static final char FORBIDDEN_LEADING_AND_TRAILING_CHARACTER = '.';
    private static final char REPLACEMENT_CHARACTER = '_';

    private NameValidator() {
    }

    public static void validate(String name, String nameDescription, String fixSuggestion) {
        if (StringUtils.isEmpty((String)name)) {
            DeprecationLogger.nagUserOfDeprecatedThing("The " + nameDescription + " is empty", fixSuggestion);
        } else if (StringUtils.containsAny((String)name, (char[])FORBIDDEN_CHARACTERS)) {
            DeprecationLogger.nagUserOfDeprecatedThing("The " + nameDescription + " '" + name + "' contains at least one of the following characters: " + Arrays.toString(FORBIDDEN_CHARACTERS), fixSuggestion);
        } else if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            DeprecationLogger.nagUserOfDeprecatedThing("The " + nameDescription + " '" + name + "' starts or ends with a '" + '.' + "'", fixSuggestion);
        }
    }

    public static String asValidName(String name) {
        return name;
    }
}

