/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.internal.NativeBuildConfigGsonUtil;
import com.android.build.gradle.internal.NativeDependencyLinkage;
import com.android.build.gradle.internal.dependency.ArtifactContainer;
import com.android.build.gradle.internal.gson.FileGsonTypeAdaptor;
import com.android.build.gradle.managed.JsonConfigFile;
import com.android.build.gradle.managed.NativeBuildConfig;
import com.android.build.gradle.managed.NativeLibrary;
import com.android.build.gradle.model.AndroidComponentModelPlugin;
import com.android.build.gradle.model.ExternalNativeBinarySpec;
import com.android.build.gradle.model.ExternalNativeComponentSpec;
import com.android.build.gradle.model.NativeComponentModelBuilder;
import com.android.build.gradle.model.internal.DefaultExternalNativeBinarySpec;
import com.android.build.gradle.model.internal.DefaultExternalNativeComponentSpec;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.utils.NativeSourceFileExtensions;
import com.android.utils.StringHelper;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.Exec;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.ModelSet;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ExternalNativeComponentModelPlugin
implements Plugin<Project> {
    public static final String COMPONENT_NAME = "androidNative";
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final ModelRegistry modelRegistry;

    @Inject
    private ExternalNativeComponentModelPlugin(ToolingModelBuilderRegistry toolingRegistry, ModelRegistry modelRegistry) {
        this.toolingRegistry = toolingRegistry;
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        AndroidComponentModelPlugin.checkPluginVersion();
        project.getPlugins().apply(LifecycleBasePlugin.class);
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        this.toolingRegistry.register((ToolingModelBuilder)new NativeComponentModelBuilder(this.modelRegistry));
    }

    private static String getAssembleTaskName(String libraryName) {
        return "create" + StringHelper.capitalize((String)libraryName);
    }

    public static class Rules
    extends RuleSource {
        @ComponentType
        public static void defineComponentType(TypeBuilder<ExternalNativeComponentSpec> builder) {
            builder.defaultImplementation(DefaultExternalNativeComponentSpec.class);
        }

        @ComponentType
        public static void defineBinaryType(TypeBuilder<ExternalNativeBinarySpec> builder) {
            builder.defaultImplementation(DefaultExternalNativeBinarySpec.class);
        }

        @Model(value="nativeBuildSystems")
        public static List<String> createBuildSystemList() {
            return Lists.newArrayList((Object[])new String[]{NativeBuildSystem.UNKNOWN.getName()});
        }

        @Model(value="nativeBuildConfig")
        public static void createNativeBuildModel(NativeBuildConfig config) {
            config.getLibraries().afterEach(nativeLibrary -> nativeLibrary.setAssembleTaskName(ExternalNativeComponentModelPlugin.getAssembleTaskName(nativeLibrary.getName())));
        }

        @Model(value="nativeBuild")
        public static void createConfigFilesModel(ModelSet<JsonConfigFile> configFiles) {
        }

        @Defaults
        public static void readJson(NativeBuildConfig config, ModelSet<JsonConfigFile> configFiles, ServiceRegistry registry) throws IOException {
            for (JsonConfigFile configFile : configFiles) {
                if (configFile.getConfigs().isEmpty()) {
                    throw new InvalidUserDataException("Config file set cannot be empty");
                }
                boolean missingConfig = false;
                for (File file : configFile.getConfigs()) {
                    if (file.exists()) continue;
                    missingConfig = true;
                }
                if (missingConfig) continue;
                FileResolver fileResolver = (FileResolver)registry.get(FileResolver.class);
                Gson gson = new GsonBuilder().registerTypeAdapter(File.class, (Object)new FileGsonTypeAdaptor(fileResolver)).create();
                for (File file : configFile.getConfigs()) {
                    NativeBuildConfigValue jsonConfig = (NativeBuildConfigValue)gson.fromJson((Reader)new FileReader(file), NativeBuildConfigValue.class);
                    NativeBuildConfigGsonUtil.copyToNativeBuildConfig(jsonConfig, config);
                }
            }
        }

        @Finalize
        static void finalizeNativeBuildConfig(NativeBuildConfig config) {
            if (config.getcFileExtensions().isEmpty()) {
                config.getcFileExtensions().addAll(NativeSourceFileExtensions.C_FILE_EXTENSIONS);
            }
            if (config.getCppFileExtensions().isEmpty()) {
                config.getCppFileExtensions().addAll(NativeSourceFileExtensions.CPP_FILE_EXTENSIONS);
            }
        }

        @Mutate
        public static void createExternalNativeComponent(ModelMap<ExternalNativeComponentSpec> components, NativeBuildConfig config) {
            components.create(ExternalNativeComponentModelPlugin.COMPONENT_NAME, component -> component.setConfig(config));
        }

        @ComponentBinaries
        public static void createExternalNativeBinary(ModelMap<ExternalNativeBinarySpec> binaries, ExternalNativeComponentSpec component) {
            for (NativeLibrary lib : component.getConfig().getLibraries()) {
                binaries.create(lib.getName(), binary -> binary.setConfig(lib));
            }
        }

        @BinaryTasks
        public static void createTasks(ModelMap<Task> tasks, ExternalNativeBinarySpec binary) {
            tasks.create(ExternalNativeComponentModelPlugin.getAssembleTaskName(binary.getName()), Exec.class, exec -> exec.setCommandLine((Iterable)StringHelper.tokenizeString((String)binary.getConfig().getBuildCommand())));
        }

        @Mutate
        public static void createGeneratorTasks(ModelMap<Task> tasks, ModelSet<JsonConfigFile> configFiles) {
            LinkedList generatorTasks = Lists.newLinkedList();
            int generateTaskIndex = 0;
            for (JsonConfigFile configFile : configFiles) {
                if (configFile.getCommand() == null) continue;
                String taskName = "generateConfigFiles" + generateTaskIndex++;
                generatorTasks.add(taskName);
                tasks.create(taskName, Exec.class, task -> task.commandLine((Iterable)StringHelper.tokenizeString((String)configFile.getCommand())));
            }
            tasks.create("generateConfigFiles", task -> {
                task.setDescription("Create configuration files for the plugin.");
                task.dependsOn(new Object[]{generatorTasks});
            });
        }

        @Mutate
        static void createCleanTask(ModelMap<Task> tasks, NativeBuildConfig config) {
            if (config.getCleanCommands().isEmpty()) {
                return;
            }
            LinkedList generatorTasks = Lists.newLinkedList();
            int cleanTaskIndex = 0;
            for (String cleanCommand : config.getCleanCommands()) {
                String taskName = "cleanNativeBuild" + cleanTaskIndex++;
                generatorTasks.add(taskName);
                tasks.create(taskName, Exec.class, task -> task.commandLine((Iterable)StringHelper.tokenizeString((String)cleanCommand)));
            }
            tasks.named("clean", task -> task.dependsOn(new Object[]{generatorTasks}));
        }

        @Model(value="artifacts")
        public static void createNativeLibraryArtifacts(ArtifactContainer artifactContainer, NativeBuildConfig config, ModelMap<Task> tasks) {
            for (NativeLibrary lib : config.getLibraries()) {
                artifactContainer.getNativeArtifacts().create(lib.getName(), artifacts -> {
                    artifacts.getLibraries().add(lib.getOutput());
                    artifacts.setAbi(lib.getAbi());
                    artifacts.setTarget(lib.getArtifactName());
                    artifacts.setVariantName(lib.getName());
                    artifacts.setBuildType(lib.getBuildType());
                    if (lib.getOutput() != null) {
                        artifacts.setLinkage(lib.getOutput().getName().endsWith(".so") ? NativeDependencyLinkage.SHARED : NativeDependencyLinkage.STATIC);
                    }
                    artifacts.setBuiltBy(Lists.newArrayList((Object[])new Object[]{tasks.get("create" + StringHelper.capitalize((String)lib.getName()))}));
                });
            }
        }
    }
}

