/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class NoCacheJarClassFileEntry
implements ClassFileEntry {
    private final ZipEntry entry;
    private final ZipFile zipFile;
    private final ClassFileInput input;

    public NoCacheJarClassFileEntry(ZipEntry entry, ZipFile zipFile, ClassFileInput input) {
        this.entry = entry;
        this.zipFile = zipFile;
        this.input = input;
    }

    @Override
    public String name() {
        return "Zip:" + this.entry.getName();
    }

    @Override
    public long getSize() {
        return this.entry.getSize();
    }

    @Override
    public String getRelativePath() {
        return this.entry.getName();
    }

    @Override
    public ClassFileInput getInput() {
        return this.input;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return ByteStreams.toByteArray((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)));
    }

    @Override
    public int readAllBytes(byte[] bytes) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(this.zipFile.getInputStream(this.entry));){
            int n = ByteStreams.read((InputStream)is, (byte[])bytes, (int)0, (int)bytes.length);
            return n;
        }
    }
}

