/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class RuntimeAnnotatedClassDetector {
    private RuntimeAnnotatedClassDetector() {
    }

    public static boolean hasRuntimeAnnotations(byte[] classDef) {
        HasRuntimeAnnotationsClassVisitor visitor = new HasRuntimeAnnotationsClassVisitor();
        new ClassReader(classDef).accept((ClassVisitor)visitor, 7);
        return visitor.hasVisibleAnnotation();
    }

    static final class HasRuntimeAnnotationsClassVisitor
    extends ClassVisitor {
        private boolean hasVisibleAnnotation;

        public HasRuntimeAnnotationsClassVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.hasVisibleAnnotation |= visible;
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.hasVisibleAnnotation) {
                return null;
            }
            return new MethodVisitor(this.api){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    hasVisibleAnnotation = hasVisibleAnnotation | visible;
                    return null;
                }
            };
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (this.hasVisibleAnnotation) {
                return null;
            }
            return new FieldVisitor(this.api){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    hasVisibleAnnotation = hasVisibleAnnotation | visible;
                    return null;
                }
            };
        }

        public boolean hasVisibleAnnotation() {
            return this.hasVisibleAnnotation;
        }
    }
}

