/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.utils.ArchiveBuilder;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DirectoryBuilder;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;

@KeepForSubclassing
public interface DexFilePerClassFileConsumer
extends ProgramConsumer {
    public void accept(String var1, byte[] var2, Set<String> var3, DiagnosticsHandler var4);

    public static DexFilePerClassFileConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    @Keep
    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResouces;

        private static String getDexFileName(String classDescriptor) {
            assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
            return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".dex";
        }

        public DirectoryConsumer(Path directory) {
            this(directory, null, false);
        }

        public DirectoryConsumer(Path directory, boolean consumeDataResouces) {
            this(directory, null, consumeDataResouces);
        }

        public DirectoryConsumer(Path directory, DexFilePerClassFileConsumer consumer) {
            this(directory, consumer, false);
        }

        public DirectoryConsumer(Path directory, DexFilePerClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new DirectoryBuilder(directory);
            this.consumeDataResouces = consumeDataResouces;
        }

        @Override
        public void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(primaryClassDescriptor, data, descriptors, handler);
            this.outputBuilder.addFile(DirectoryConsumer.getDexFileName(primaryClassDescriptor), data, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }

        public static void writeResources(Path directory, List<ProgramResource> resources, Map<Resource, String> primaryClassDescriptors) throws IOException, ResourceException {
            try (Closer closer = Closer.create();){
                for (ProgramResource resource : resources) {
                    String primaryClassDescriptor = primaryClassDescriptors.get(resource);
                    Path target = DirectoryConsumer.getTargetDexFile(directory, primaryClassDescriptor);
                    DirectoryConsumer.writeFile(ByteStreams.toByteArray(closer.register(resource.getByteStream())), target);
                }
            }
        }

        private static Path getTargetDexFile(Path directory, String primaryClassDescriptor) {
            return directory.resolve(ArchiveConsumer.getDexFileName(primaryClassDescriptor));
        }

        private static void writeFile(byte[] contents, Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, contents);
        }
    }

    @Keep
    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResources;

        private static String getDexFileName(String classDescriptor) {
            assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
            return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".dex";
        }

        public ArchiveConsumer(Path archive) {
            this(archive, null, false);
        }

        public ArchiveConsumer(Path archive, boolean consumeDataResouces) {
            this(archive, null, consumeDataResouces);
        }

        public ArchiveConsumer(Path archive, DexFilePerClassFileConsumer consumer) {
            this(archive, consumer, false);
        }

        public ArchiveConsumer(Path archive, DexFilePerClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new ArchiveBuilder(archive);
            this.consumeDataResources = consumeDataResouces;
            this.outputBuilder.open();
            if (this.getDataResourceConsumer() != null) {
                this.outputBuilder.open();
            }
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResources ? this : null;
        }

        @Override
        public void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(primaryClassDescriptor, data, descriptors, handler);
            this.outputBuilder.addFile(ArchiveConsumer.getDexFileName(primaryClassDescriptor), data, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }

        public static void writeResources(Path archive, List<ProgramResource> resources, Map<Resource, String> primaryClassDescriptors) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            try (Closer closer = Closer.create();
                 ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
                for (ProgramResource resource : resources) {
                    String primaryClassDescriptor = primaryClassDescriptors.get(resource);
                    String entryName = ArchiveConsumer.getDexFileName(primaryClassDescriptor);
                    byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
                    ZipUtils.writeToZipStream(out, entryName, bytes, 0);
                }
            }
        }
    }

    @Keep
    public static class ForwardingConsumer
    implements DexFilePerClassFileConsumer {
        private static final DexFilePerClassFileConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final DexFilePerClassFileConsumer consumer;

        public ForwardingConsumer(DexFilePerClassFileConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumer != null ? this.consumer.getDataResourceConsumer() : null;
        }

        @Override
        public void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(primaryClassDescriptor, data, descriptors, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

