/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.utils.LebUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DebugBytecodeWriter {
    private final ObjectToOffsetMapping mapping;
    private final DexDebugInfo info;
    private ByteBuffer buffer;

    public DebugBytecodeWriter(DexDebugInfo info, ObjectToOffsetMapping mapping) {
        this.info = info;
        this.mapping = mapping;
        this.buffer = ByteBuffer.allocate(info.events.length * 5 + 4);
    }

    public byte[] generate() {
        this.putUleb128(this.info.startLine);
        this.putUleb128(this.info.parameters.length);
        for (DexString dexString : this.info.parameters) {
            this.putString(dexString);
        }
        for (DexItem dexItem : this.info.events) {
            ((DexDebugEvent)dexItem).writeOn(this, this.mapping);
        }
        this.putByte(0);
        return Arrays.copyOf(this.buffer.array(), this.buffer.position());
    }

    private void maybeGrow(int size) {
        if (this.buffer.remaining() < size) {
            ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() * 2);
            newBuffer.put(this.buffer.array(), 0, this.buffer.position());
            this.buffer = newBuffer;
        }
    }

    public void putByte(int item) {
        this.maybeGrow(1);
        this.buffer.put((byte)item);
    }

    public void putSleb128(int item) {
        byte[] encoded = LebUtils.encodeSleb128(item);
        this.maybeGrow(encoded.length);
        this.buffer.put(encoded, 0, encoded.length);
    }

    public void putUleb128(int item) {
        byte[] encoded = LebUtils.encodeUleb128(item);
        this.maybeGrow(encoded.length);
        this.buffer.put(encoded, 0, encoded.length);
    }

    private void putUleb128p1(int item) {
        this.putUleb128(item + 1);
    }

    private void putNoIndex() {
        this.putUleb128(0);
    }

    public void putType(DexType type) {
        if (type == null) {
            this.putNoIndex();
        } else {
            int index = this.mapping.getOffsetFor(type);
            this.putUleb128p1(index);
        }
    }

    public void putString(DexString string) {
        if (string == null) {
            this.putNoIndex();
        } else {
            int index = this.mapping.getOffsetFor(string);
            this.putUleb128p1(index);
        }
    }
}

