/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kotlin;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupClassBuilder;
import com.android.tools.r8.ir.optimize.lambda.kotlin.ClassInitializerSourceCode;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaConstants;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupId;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaVirtualMethodSourceCode;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.android.tools.r8.ir.synthetic.SyntheticSourceCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

abstract class KotlinLambdaGroupClassBuilder<T extends KotlinLambdaGroup>
extends LambdaGroupClassBuilder<T>
implements KotlinLambdaConstants {
    final KotlinLambdaGroupId id;

    KotlinLambdaGroupClassBuilder(T group, DexItemFactory factory, String origin) {
        super(group, factory, origin);
        this.id = ((KotlinLambdaGroup)group).id();
    }

    abstract SyntheticSourceCode createInstanceInitializerSourceCode(DexType var1, DexProto var2);

    @Override
    protected ClassAccessFlags buildAccessFlags() {
        return PUBLIC_LAMBDA_CLASS_FLAGS;
    }

    @Override
    protected EnclosingMethodAttribute buildEnclosingMethodAttribute() {
        return this.id.enclosing;
    }

    @Override
    protected List<InnerClassAttribute> buildInnerClasses() {
        return !this.id.hasInnerClassAttribute() ? Collections.emptyList() : Lists.newArrayList(new InnerClassAttribute(this.id.innerClassAccess, ((KotlinLambdaGroup)this.group).getGroupClassType(), null, null));
    }

    @Override
    protected DexAnnotationSet buildAnnotations() {
        String signature = this.id.signature;
        return signature == null ? DexAnnotationSet.empty() : new DexAnnotationSet(new DexAnnotation[]{DexAnnotation.createSignatureAnnotation(signature, this.factory)});
    }

    @Override
    protected DexEncodedMethod[] buildVirtualMethods() {
        Map<DexString, Map<DexProto, List<DexEncodedMethod>>> methods = this.collectVirtualMethods();
        ArrayList<DexEncodedMethod> result = new ArrayList<DexEncodedMethod>();
        for (Map.Entry<DexString, Map<DexProto, List<DexEncodedMethod>>> upper : methods.entrySet()) {
            DexString methodName = upper.getKey();
            for (Map.Entry<DexProto, List<DexEncodedMethod>> inner : upper.getValue().entrySet()) {
                DexProto methodProto = inner.getKey();
                List<DexEncodedMethod> implMethods = inner.getValue();
                boolean isMainMethod = this.id.mainMethodName == methodName && this.id.mainMethodProto == methodProto;
                MethodAccessFlags accessFlags = MAIN_METHOD_FLAGS.copy();
                for (DexEncodedMethod implMethod : implMethods) {
                    if (implMethod == null) continue;
                    implMethod.markForceInline();
                }
                result.add(new DexEncodedMethod(this.factory.createMethod(((KotlinLambdaGroup)this.group).getGroupClassType(), methodProto, methodName), accessFlags, isMainMethod ? this.id.mainMethodAnnotations : DexAnnotationSet.empty(), isMainMethod ? this.id.mainMethodParamAnnotations : ParameterAnnotationsList.empty(), new SynthesizedCode(new KotlinLambdaVirtualMethodSourceCode(this.factory, ((KotlinLambdaGroup)this.group).getGroupClassType(), methodProto, ((KotlinLambdaGroup)this.group).getLambdaIdField(this.factory), implMethods))));
            }
        }
        return result.toArray(new DexEncodedMethod[result.size()]);
    }

    private Map<DexString, Map<DexProto, List<DexEncodedMethod>>> collectVirtualMethods() {
        LinkedHashMap<DexString, Map<DexProto, List<DexEncodedMethod>>> methods = new LinkedHashMap<DexString, Map<DexProto, List<DexEncodedMethod>>>();
        int size = ((KotlinLambdaGroup)this.group).size();
        ((KotlinLambdaGroup)this.group).forEachLambda(info -> {
            for (DexEncodedMethod method : info.clazz.virtualMethods()) {
                List list = methods.computeIfAbsent(method.method.name, k -> new LinkedHashMap()).computeIfAbsent(method.method.proto, k -> Lists.newArrayList(Collections.nCopies(size, null)));
                assert (list.get(info.id) == null);
                list.set(info.id, method);
            }
        });
        return methods;
    }

    @Override
    protected DexEncodedMethod[] buildDirectMethods() {
        boolean needsSingletonInstances = ((KotlinLambdaGroup)this.group).isStateless() && ((KotlinLambdaGroup)this.group).hasAnySingletons();
        DexType groupClassType = ((KotlinLambdaGroup)this.group).getGroupClassType();
        DexEncodedMethod[] result = new DexEncodedMethod[needsSingletonInstances ? 2 : 1];
        DexProto initializerProto = ((KotlinLambdaGroup)this.group).createConstructorProto(this.factory);
        result[0] = new DexEncodedMethod(this.factory.createMethod(groupClassType, initializerProto, this.factory.constructorMethodName), CONSTRUCTOR_FLAGS_RELAXED, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(this.createInstanceInitializerSourceCode(groupClassType, initializerProto)));
        if (needsSingletonInstances) {
            result[1] = new DexEncodedMethod(this.factory.createMethod(groupClassType, this.factory.createProto(this.factory.voidType, new DexType[0]), this.factory.classConstructorMethodName), CLASS_INITIALIZER_FLAGS, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(new ClassInitializerSourceCode(this.factory, (KotlinLambdaGroup)this.group)));
        }
        return result;
    }

    @Override
    protected DexEncodedField[] buildInstanceFields() {
        String capture = this.id.capture;
        int size = capture.length();
        DexEncodedField[] result = new DexEncodedField[1 + size];
        result[0] = new DexEncodedField(((KotlinLambdaGroup)this.group).getLambdaIdField(this.factory), CAPTURE_FIELD_FLAGS_RELAXED, DexAnnotationSet.empty(), null);
        for (int id = 0; id < size; ++id) {
            result[id + 1] = new DexEncodedField(((KotlinLambdaGroup)this.group).getCaptureField(this.factory, id), CAPTURE_FIELD_FLAGS_RELAXED, DexAnnotationSet.empty(), null);
        }
        return result;
    }

    @Override
    protected DexEncodedField[] buildStaticFields() {
        if (!((KotlinLambdaGroup)this.group).isStateless()) {
            return DexEncodedField.EMPTY_ARRAY;
        }
        ArrayList result = new ArrayList(((KotlinLambdaGroup)this.group).size());
        ((KotlinLambdaGroup)this.group).forEachLambda(info -> {
            if (((KotlinLambdaGroup)this.group).isSingletonLambda(info.clazz.type)) {
                result.add(new DexEncodedField(((KotlinLambdaGroup)this.group).getSingletonInstanceField(this.factory, info.id), SINGLETON_FIELD_FLAGS, DexAnnotationSet.empty(), DexValue.DexValueNull.NULL));
            }
        });
        assert (result.isEmpty() == !((KotlinLambdaGroup)this.group).hasAnySingletons());
        return result.toArray(new DexEncodedField[result.size()]);
    }

    @Override
    protected DexTypeList buildInterfaces() {
        return new DexTypeList(new DexType[]{this.id.iface});
    }
}

