/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.shaking.ProguardPathList;

public class ProguardPathFilter {
    private final ImmutableList<ProguardPathList> patterns;

    public static Builder builder() {
        return new Builder();
    }

    private ProguardPathFilter(ImmutableList<ProguardPathList> patterns) {
        this.patterns = patterns.isEmpty() ? ImmutableList.of(ProguardPathList.emptyList()) : patterns;
    }

    public boolean matches(String path) {
        for (ProguardPathList pattern : this.patterns) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private final ImmutableList.Builder<ProguardPathList> patterns = ImmutableList.builder();

        private Builder() {
        }

        public Builder addPattern(ProguardPathList pattern) {
            this.patterns.add((Object)pattern);
            return this;
        }

        ProguardPathFilter build() {
            return new ProguardPathFilter((ImmutableList)this.patterns.build());
        }
    }
}

