/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;

public class FileCacheByPath {
    private final File mDirectory;

    public FileCacheByPath(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        this.mDirectory = directory;
    }

    public void add(File f) throws IOException {
        Preconditions.checkArgument((boolean)f.isFile(), (Object)"!f.isFile()");
        if (!this.mDirectory.isDirectory()) {
            FileUtils.mkdirs((File)this.mDirectory);
        }
        String k = FileCacheByPath.key(f);
        Files.copy((File)f, (File)new File(this.mDirectory, k));
    }

    public File get(File f) {
        File file = new File(this.mDirectory, FileCacheByPath.key(f));
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public void remove(File f) throws IOException {
        File toRemove = new File(this.mDirectory, FileCacheByPath.key(f));
        if (toRemove.exists()) {
            FileUtils.delete((File)toRemove);
        }
    }

    private static String key(File f) {
        String absolutePath = f.getAbsolutePath();
        byte[] sha1Sum = Hashing.sha1().hashString((CharSequence)absolutePath, Charsets.UTF_8).asBytes();
        return new String(Base64.encodeBase64((byte[])sha1Sum), Charsets.US_ASCII).replaceAll("/", "_");
    }

    public void clear() throws IOException {
        File[] files = this.mDirectory.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.isFile()) continue;
            FileUtils.delete((File)f);
        }
    }
}

