/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.RelativeFile;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class RelativeFiles {
    public static final Predicate<RelativeFile> IS_FILE = relativeFile -> relativeFile.getFile().isFile();

    private RelativeFiles() {
    }

    public static Set<RelativeFile> fromDirectory(File directory) {
        return RelativeFiles.fromDirectory(directory, directory);
    }

    public static ImmutableSet<RelativeFile> fromDirectory(File directory, Predicate<RelativeFile> filter) {
        return ImmutableSet.copyOf((Collection)Sets.filter(RelativeFiles.fromDirectory(directory, directory), filter));
    }

    private static ImmutableSet<RelativeFile> fromDirectory(File base, File directory) {
        File[] directoryFiles;
        Preconditions.checkArgument((boolean)base.isDirectory(), (Object)"!base.isDirectory()");
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        HashSet files = Sets.newHashSet();
        for (File file : directoryFiles = (File[])Verify.verifyNotNull((Object)directory.listFiles(), (String)"directory.listFiles() == null", (Object[])new Object[0])) {
            files.add(new RelativeFile(base, file));
            if (!file.isDirectory()) continue;
            files.addAll(RelativeFiles.fromDirectory(base, file));
        }
        return ImmutableSet.copyOf((Collection)files);
    }

    public static Predicate<RelativeFile> fromPathPredicate(Predicate<String> predicate) {
        return Predicates.compose(predicate, RelativeFile.EXTRACT_PATH);
    }
}

