/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.internal.compiler.PreProcessCache;
import com.android.repository.Revision;
import com.google.common.base.Objects;
import java.io.File;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DexKey
extends PreProcessCache.Key {
    protected static final String ATTR_JUMBO_MODE = "jumboMode";
    protected static final String ATTR_OPTIMIZE = "optimize";
    private final boolean mJumboMode;
    private final boolean mOptimize;

    protected DexKey(File sourceFile, Revision buildToolsRevision, boolean jumboMode, boolean optimize) {
        super(sourceFile, buildToolsRevision);
        this.mJumboMode = jumboMode;
        this.mOptimize = optimize;
    }

    protected void writeFieldsToXml(Node itemNode) {
        Document document = itemNode.getOwnerDocument();
        Attr jumboMode = document.createAttribute(ATTR_JUMBO_MODE);
        jumboMode.setValue(Boolean.toString(this.mJumboMode));
        itemNode.getAttributes().setNamedItem(jumboMode);
        Attr optimize = document.createAttribute(ATTR_OPTIMIZE);
        optimize.setValue(Boolean.toString(this.mOptimize));
        itemNode.getAttributes().setNamedItem(optimize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DexKey dexKey = (DexKey)o;
        return this.mJumboMode == dexKey.mJumboMode && this.mOptimize == dexKey.mOptimize;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mJumboMode, this.mOptimize});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("buildTools", (Object)this.getBuildToolsRevision()).add("sourceFile", (Object)this.getSourceFile()).add("mJumboMode", this.mJumboMode).add("mOptimize", this.mOptimize).toString();
    }
}

