/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.internal.compiler.DxDexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PreDexCache
extends PreProcessCache<DxDexKey> {
    private static final PreDexCache sSingleton = new PreDexCache();

    public static PreDexCache getCache() {
        return sSingleton;
    }

    @Override
    protected PreProcessCache.KeyFactory<DxDexKey> getKeyFactory() {
        return DxDexKey.FACTORY;
    }

    public void preDexLibrary(AndroidBuilder builder, File inputFile, File outFile, boolean multiDex, DexOptions dexOptions, boolean optimize, ProcessOutputHandler processOutputHandler) throws IOException, ProcessException, InterruptedException {
        Preconditions.checkState((!multiDex || outFile.isDirectory() ? 1 : 0) != 0);
        Preconditions.checkState((builder.getTargetInfo() != null ? 1 : 0) != 0);
        optimize = true;
        DxDexKey itemKey = DxDexKey.of(inputFile, builder.getTargetInfo().getBuildTools().getRevision(), dexOptions.getJumboMode(), optimize, dexOptions.getAdditionalParameters(), multiDex);
        ILogger logger = builder.getLogger();
        logger.info("preDexLibrary : %s", new Object[]{itemKey});
        Pair<PreProcessCache.Item, Boolean> pair = this.getItem(logger, itemKey);
        PreProcessCache.Item item = (PreProcessCache.Item)pair.getFirst();
        logger.info("Item from cache %s", new Object[]{item.toString()});
        if (!((Boolean)pair.getSecond()).booleanValue()) {
            if (this.waitForPredexFile(item, outFile, multiDex)) {
                return;
            }
            logger.info("Forced regeneration : %s", new Object[]{itemKey});
            pair = this.regenerateItem(logger, itemKey);
            item = (PreProcessCache.Item)pair.getFirst();
        }
        if (((Boolean)pair.getSecond()).booleanValue()) {
            try {
                ImmutableList<File> files = builder.preDexLibraryNoCache(inputFile, outFile, multiDex, dexOptions, optimize, processOutputHandler);
                item.getOutputFiles().clear();
                item.getOutputFiles().addAll((Collection<File>)files);
                this.incrementMisses();
            }
            catch (ProcessException exception) {
                FileUtils.deleteIfExists((File)outFile);
                throw exception;
            }
            finally {
                item.getLatch().countDown();
            }
        } else if (!this.waitForPredexFile(item, outFile, multiDex)) {
            throw new RuntimeException(String.format("Cannot obtain or regenerate item %s", item.getSourceFile()));
        }
    }

    private boolean waitForPredexFile(PreProcessCache.Item item, File outFile, boolean multiDex) throws InterruptedException, IOException {
        item.getLatch().await();
        if (item.areOutputFilesPresent()) {
            if (multiDex) {
                for (File sourceFile : item.getOutputFiles()) {
                    File destFile = new File(outFile, sourceFile.getName());
                    PreDexCache.checkSame(sourceFile, destFile);
                    Files.copy((File)sourceFile, (File)destFile);
                }
            } else {
                if (item.getOutputFiles().isEmpty()) {
                    throw new RuntimeException(item.toString());
                }
                PreDexCache.checkSame(item.getOutputFiles().get(0), outFile);
                Files.copy((File)item.getOutputFiles().get(0), (File)outFile);
            }
            this.incrementHits();
            return true;
        }
        return false;
    }

    @Override
    protected Node createItemNode(Document document, DxDexKey itemKey, PreProcessCache.BaseItem item) throws IOException {
        Node itemNode = super.createItemNode(document, itemKey, item);
        if (itemNode != null) {
            itemKey.writeFieldsToXml(itemNode);
        }
        return itemNode;
    }

    private static void checkSame(File source, File dest) {
        if (source.equals(dest)) {
            Logger.getAnonymousLogger().info(String.format("%s l:%d ts:%d", source, source.length(), source.lastModified()));
        }
    }
}

