/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip.compress;

import com.android.builder.internal.packaging.zip.CompressionMethod;
import com.android.builder.internal.packaging.zip.CompressionResult;
import com.android.builder.internal.packaging.zip.compress.ExecutorCompressor;
import com.android.builder.internal.packaging.zip.utils.ByteTracker;
import com.android.builder.internal.packaging.zip.utils.CloseableByteSource;
import com.android.builder.internal.packaging.zip.utils.CloseableDelegateByteSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class DeflateExecutionCompressor
extends ExecutorCompressor {
    private final int mLevel;
    private final ByteTracker mTracker;

    public DeflateExecutionCompressor(Executor executor, ByteTracker tracker, int level) {
        super(executor);
        this.mLevel = level;
        this.mTracker = tracker;
    }

    @Override
    protected CompressionResult immediateCompress(CloseableByteSource source) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(this.mLevel, true);
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)output, deflater);){
            dos.write(source.read());
        }
        CloseableDelegateByteSource result = this.mTracker.fromStream(output);
        if (result.size() >= source.size()) {
            return new CompressionResult(source, CompressionMethod.STORE, source.size());
        }
        return new CompressionResult(result, CompressionMethod.DEFLATE, result.size());
    }
}

