package ${packageName};

<#if hasAppBar>
<#if features == 'tabs'>
import ${getMaterialComponentName('android.support.design.widget.TabLayout', useMaterial2)};
</#if>
import ${getMaterialComponentName('android.support.design.widget.FloatingActionButton', useMaterial2)};
import ${getMaterialComponentName('android.support.design.widget.Snackbar', useMaterial2)};
import ${getMaterialComponentName('android.support.v7.app.AppCompatActivity', useAndroidX)};
import ${getMaterialComponentName('android.support.v7.widget.Toolbar', useAndroidX)};
<#else>  <#-- hasAppBar -->
import ${superClassFqcn};
<#if useAndroidX>
import ${getMaterialComponentName('android.support.v7.app.ActionBar', useAndroidX)};
import ${getMaterialComponentName('android.support.v4.app.FragmentTransaction', useAndroidX)};
<#else>
import android.<#if appCompat>support.v7.</#if>app.ActionBar;
import android.<#if appCompat>support.v4.</#if>app.FragmentTransaction;
</#if>
</#if>   <#-- hasAppBar -->
<#if useAndroidX>
import ${getMaterialComponentName('android.support.v4.app.Fragment', useAndroidX)};
<#else>
import android.<#if appCompat>support.v4.</#if>app.Fragment;
</#if>
<#if hasViewPager>
<#if useAndroidX>
import ${getMaterialComponentName('android.support.v4.app.FragmentManager', useAndroidX)};
<#else>
import android.<#if appCompat>support.v4.</#if>app.FragmentManager;
</#if>
<#if useAndroidX>
import ${getMaterialComponentName('android.support.v4.app.FragmentPagerAdapter', useAndroidX)};
<#else>
<#if useAndroidX>
import ${getMaterialComponentName('android.support.'v4'.app.FragmentPagerAdapter', useAndroidX)};
<#else>
import android.support.${(appCompat)?string('v4','v13')}.app.FragmentPagerAdapter;
</#if>
</#if>
import ${getMaterialComponentName('android.support.v4.view.ViewPager', useAndroidX)};
</#if>
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
<#if features == 'spinner'>
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.content.Context;
<#if buildApi gte 23>
import ${getMaterialComponentName('android.support.v7.widget.ThemedSpinnerAdapter', useAndroidX)};
import android.content.res.Resources.Theme;
<#else>
import android.graphics.Color;
</#if>
</#if>  <#-- features == 'spinner' -->
import android.widget.TextView;
<#if applicationPackage??>
import ${applicationPackage}.R;
</#if>

public class ${activityClass} extends ${superClass}<#if !hasAppBar && features == 'tabs'> implements ActionBar.TabListener</#if> {

    <#if hasViewPager>
    /**
     * The {@link ${getMaterialComponentName('android.support.v4.view.PagerAdapter', useAndroidX)}} that will provide
     * fragments for each of the sections. We use a
     * {@link FragmentPagerAdapter} derivative, which will keep every
     * loaded fragment in memory. If this becomes too memory intensive, it
     * may be best to switch to a
     * <#if useAndroidX>${getMaterialComponentName('android.support.v4.app.FragmentStatePagerAdapter', useAndroidX)}<#else>{@link android.support.${(appCompat)?string('v4','v13')}.app.FragmentStatePagerAdapter}</#if>.
     */
    private SectionsPagerAdapter mSectionsPagerAdapter;

    /**
     * The {@link ViewPager} that will host the section contents.
     */
    private ViewPager mViewPager;

    </#if>
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.${layoutName});
    <#if hasAppBar>

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);
    </#if>
    <#if parentActivityClass != "">
        get${Support}ActionBar().setDisplayHomeAsUpEnabled(true);
    </#if>
    <#if hasViewPager>
        // Create the adapter that will return a fragment for each of the three
        // primary sections of the activity.
        mSectionsPagerAdapter = new SectionsPagerAdapter(get${Support}FragmentManager());

        // Set up the ViewPager with the sections adapter.
        mViewPager = (ViewPager) findViewById(R.id.container);
        mViewPager.setAdapter(mSectionsPagerAdapter);
    </#if>
    <#if hasAppBar>
      <#if features == 'tabs'>

         TabLayout tabLayout = (TabLayout) findViewById(R.id.tabs);

        mViewPager.addOnPageChangeListener(new TabLayout.TabLayoutOnPageChangeListener(tabLayout));
        tabLayout.addOnTabSelectedListener(new TabLayout.ViewPagerOnTabSelectedListener(mViewPager));
      <#elseif features == 'spinner'>
        getSupportActionBar().setDisplayShowTitleEnabled(false);

        // Setup spinner
        Spinner spinner = (Spinner) findViewById(R.id.spinner);
        spinner.setAdapter(new MyAdapter(
                toolbar.getContext(),
                new String[]{
                        "Section 1",
                        "Section 2",
                        "Section 3",
                }));

        spinner.setOnItemSelectedListener(new OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                // When the given dropdown item is selected, show its contents in the
                // container view.
                get${Support}FragmentManager().beginTransaction()
                        .replace(R.id.container, PlaceholderFragment.newInstance(position + 1))
                        .commit();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
      </#if>

      FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
      fab.setOnClickListener(new View.OnClickListener() {
          @Override
          public void onClick(View view) {
              Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
                      .setAction("Action", null).show();
          }
      });
    <#else>  <#-- hasAppBar -->
      <#if features == 'tabs'>
        // Set up the action bar.
        final ActionBar actionBar = get${Support}ActionBar();
        actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);

        // When swiping between different sections, select the corresponding
        // tab. We can also use ActionBar.Tab#select() to do this if we have
        // a reference to the Tab.
        mViewPager.setOnPageChangeListener(new ViewPager.SimpleOnPageChangeListener() {
            @Override
            public void onPageSelected(int position) {
                actionBar.setSelectedNavigationItem(position);
            }
        });

        // For each of the sections in the app, add a tab to the action bar.
        for (int i = 0; i < mSectionsPagerAdapter.getCount(); i++) {
            // Create a tab with text corresponding to the page title defined by
            // the adapter. Also specify this Activity object, which implements
            // the TabListener interface, as the callback (listener) for when
            // this tab is selected.
            actionBar.addTab(
                    actionBar.newTab()
                            .setText(mSectionsPagerAdapter.getPageTitle(i))
                            .setTabListener(this));
        }
      </#if>
    </#if>  <#-- hasAppBar -->
    }

    <#include "include_options_menu.java.ftl">

    <#if !hasAppBar && features == 'tabs'>@Override
    public void onTabSelected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
        // When the given tab is selected, switch to the corresponding page in
        // the ViewPager.
        mViewPager.setCurrentItem(tab.getPosition());
    }

    @Override
    public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
    }

    @Override
    public void onTabReselected(ActionBar.Tab tab, FragmentTransaction fragmentTransaction) {
    }
    </#if>

    <#if features == 'spinner'>
    <#if buildApi gte 23>
    private static class MyAdapter extends ArrayAdapter<String> implements ThemedSpinnerAdapter {
        private final ThemedSpinnerAdapter.Helper mDropDownHelper;

        public MyAdapter(Context context, String[] objects) {
            super(context, android.R.layout.simple_list_item_1, objects);
            mDropDownHelper = new ThemedSpinnerAdapter.Helper(context);
        }

        @Override
        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            View view;

            if (convertView == null) {
                // Inflate the drop down using the helper's LayoutInflater
                LayoutInflater inflater = mDropDownHelper.getDropDownViewInflater();
                view = inflater.inflate(android.R.layout.simple_list_item_1, parent, false);
            } else {
                view = convertView;
            }

            TextView textView = (TextView) view.findViewById(android.R.id.text1);
            textView.setText(getItem(position));

            return view;
        }

        @Override
        public void setDropDownViewTheme(Theme theme) {
            mDropDownHelper.setDropDownViewTheme(theme);
        }

        @Override
        public Theme getDropDownViewTheme() {
            return mDropDownHelper.getDropDownViewTheme();
        }
    }

    <#else>  <#-- buildApi gte 23 -->
    private static class MyAdapter extends ArrayAdapter<String> {

        public MyAdapter(Context context, String[] objects) {
            super(context, android.R.layout.simple_list_item_1, android.R.id.text1, objects);
        }

        @Override
        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            View view = super.getView(position, convertView, parent);
            TextView text = (TextView) view.findViewById(android.R.id.text1);
            // Hack. Use BuildVersion 23 for a better approach.
            text.setTextColor(Color.BLACK);
            text.setBackgroundColor(Color.WHITE);
            return view;
        }
    }
    </#if>
    </#if>  <#-- features == 'spinner' -->

    <#if hasViewPager>
    /**
     * A {@link FragmentPagerAdapter} that returns a fragment corresponding to
     * one of the sections/tabs/pages.
     */
    public class SectionsPagerAdapter extends FragmentPagerAdapter {

        public SectionsPagerAdapter(FragmentManager fm) {
            super(fm);
        }

        @Override
        public Fragment getItem(int position) {
            // getItem is called to instantiate the fragment for the given page.
            // Return a PlaceholderFragment (defined as a static inner class below).
            return PlaceholderFragment.newInstance(position + 1);
        }

        @Override
        public int getCount() {
            // Show 3 total pages.
            return 3;
        }
        <#if !appCompat>

        @Override
        public CharSequence getPageTitle(int position) {
            switch (position) {
                case 0:
                    return "SECTION 1";
                case 1:
                    return "SECTION 2";
                case 2:
                    return "SECTION 3";
            }
            return null;
        }
        </#if>
    }
    </#if>

    <#include "include_fragment.java.ftl">
}
