package ${packageName};

import android.content.Context;
import android.os.Bundle;
import ${getMaterialComponentName('android.support.annotation.Nullable', useAndroidX)};
import ${getMaterialComponentName('android.support.design.widget.BottomSheetDialog', useMaterial2)}Fragment;
import ${getMaterialComponentName('android.support.v4.app.Fragment', useAndroidX)};
<#if columnCount == "1">
import ${getMaterialComponentName('android.support.v7.widget.LinearLayoutManager', useAndroidX)};
<#else>
import ${getMaterialComponentName('android.support.v7.widget.GridLayoutManager', useAndroidX)};
</#if>
import ${getMaterialComponentName('android.support.v7.widget.RecyclerView', useAndroidX)};
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
<#if applicationPackage??>
import ${applicationPackage}.R;
</#if>

/**
 * <p>A fragment that shows a list of items as a modal bottom sheet.</p>
 * <p>You can show this modal bottom sheet from your activity like this:</p>
 * <pre>
 *     ${className}.newInstance(30).show(getSupportFragmentManager(), "dialog");
 * </pre>
 * <p>You activity (or fragment) needs to implement {@link ${className}.Listener}.</p>
 */
public class ${className} extends BottomSheetDialogFragment {

    // TODO: Customize parameter argument names
    private static final String ARG_ITEM_COUNT = "item_count";
    private Listener mListener;

    // TODO: Customize parameters
    public static ${className} newInstance(int itemCount) {
        final ${className} fragment = new ${className}();
        final Bundle args = new Bundle();
        args.putInt(ARG_ITEM_COUNT, itemCount);
        fragment.setArguments(args);
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.${listLayout}, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        final RecyclerView recyclerView = (RecyclerView) view;
<#if columnCount == "1">
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
<#else>
        recyclerView.setLayoutManager(new GridLayoutManager(getContext(), ${columnCount}));
</#if>
        recyclerView.setAdapter(new ${objectKind}Adapter(getArguments().getInt(ARG_ITEM_COUNT)));
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        final Fragment parent = getParentFragment();
        if (parent != null) {
            mListener = (Listener) parent;
        } else {
            mListener = (Listener) context;
        }
    }

    @Override
    public void onDetach() {
        mListener = null;
        super.onDetach();
    }

    public interface Listener {
        void on${objectKind}Clicked(int position);
    }

    private class ViewHolder extends RecyclerView.ViewHolder {

        final TextView text;

        ViewHolder(LayoutInflater inflater, ViewGroup parent) {
            // TODO: Customize the item layout
            super(inflater.inflate(R.layout.${itemLayout}, parent, false));
            text = (TextView) itemView.findViewById(R.id.text);
            text.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mListener != null) {
                        mListener.on${objectKind}Clicked(getAdapterPosition());
                        dismiss();
                    }
                }
            });
        }

    }

    private class ${objectKind}Adapter extends RecyclerView.Adapter<ViewHolder> {

        private final int mItemCount;

        ${objectKind}Adapter(int itemCount) {
            mItemCount = itemCount;
        }

        @Override
        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ViewHolder(LayoutInflater.from(parent.getContext()), parent);
        }

        @Override
        public void onBindViewHolder(ViewHolder holder, int position) {
            holder.text.setText(String.valueOf(position));
        }

        @Override
        public int getItemCount() {
            return mItemCount;
        }

    }

}
